;****************************************************************
; Eye Brightness Controller (Using PWM)				*
;****************************************************************
	list		p=16c73b
	#include	<p16c73b.inc>

Eye_Vars	udata
Eye_Intensity	res 1
	global Eye_Intensity
Eye_IntensityL	res 1
Eye_IntensityR	res 1
		code
;****************************************************************
; Eyes_SetIntensity						*
; Set the brightness of the eyes based upon the value of W	*
; from 0 (off) to 255 (fully on). If the brightness is zero	*
; then pins C1 and C2 will be returned to an input state and	*
; the PWM drivers disabled.					*
;****************************************************************
Eyes_SetIntensity:
	global	Eyes_SetIntensity
	bcf	STATUS,RP0
	movwf	Eye_Intensity
	movf	Eye_Intensity,f	; <- Needed to set Z, movwf doesn't
	btfss	STATUS,Z
	goto	Eyes_AboveZero
; Not only return C1 and C2 to an input state, but kill the PWM
; drivers as well. Seems that sometimes they won't release the pin.
	bsf	STATUS,RP0
	movlw	0xD7
	movwf	TRISC
	bcf	STATUS,RP0
	clrf	CCPR2L
	clrf	CCPR1L
	clrf	CCP1CON
	clrf	CCP2CON
	return

; Keep in mind that some adjustment may need to be performed
; depending upon how balanced the left and right eyes are.
Eyes_AboveZero
	bsf	STATUS,RP0
	movlw	0xD1
	movwf	TRISC
	bcf	STATUS,RP0
	movlw	0x0F
	movwf	CCP1CON
	movwf	CCP2CON

	movf	Eye_Intensity,w
	movwf	Eye_IntensityL
	movwf	CCPR2L
	movwf	Eye_IntensityR
	movwf	CCPR1L
	return
;****************************************************************
; Eyes_Init							*
; Initialize Timer 2 and the PWM Controller to generate a	*
; 39KHz pulse over CCP1 and CCP2 which can then be used to	*
; adjust the right and left eye intensity, respectively.	*
;****************************************************************
Eyes_Init:
	global Eyes_Init
; Timer 2 is used to clock the PWM hardware, and we'll be using
; a full period of $FF. As our system clock is 10MHz, this results
; in a PWM frequency of ((10MHz / 4) / 256) = ~9.765KHz.
	bcf	STATUS,RP0
	clrf	T2CON
	bsf	STATUS,RP0
	movlw	0xFF
	movwf	PR2
; Make sure our initial duty cycle is 100% so the eyes will light
; up during the rest of the startup procedure. Note that bits 4-5
; of CCPxCON can be used as extra granularity in PWM Mode, but we'll
; be ignoring them since 8-Bits is more than enough for dimming LEDs.
	bsf	STATUS,RP0
	bcf	TRISC,1
	bcf	TRISC,2

	bcf	STATUS,RP0
	movlw	0x0F
	movwf	CCP1CON
	movwf	CCP2CON
	movlw	0xFF
	movwf	CCPR1L
	movwf	CCPR2L
; Set Timer 2, and that's it for now.
	bsf	T2CON,TMR2ON
; Pins C1 and C2 (Eye R, Eye L) will be left in input mode until
; the eyes are enabled, and we'll hold off on turning on the
; PWM drivers until then as well.
	return
	END
