;****************************************************************
;		   Sylvie the Mischievous Pony			*
;****************************************************************
; Sylvie spent most of her life leisurely grazing on wall to wall
; carpeting and conversing with the other toybox denizens about
; the dissapointing state of televised entertainment. Her owner
; was a quiet girl who would craft lavish adventures for Sylvie
; to experience. Until she grew older, and much bolder.
; The plastic horse was left on the curbside in favor of taking a
; motorbike and Casio CZ-101 to the edge of the world. Sylvie
; understood, but still felt abandoned.
;
; ...until we found her for $5 at a used toy store and filled
; her empty heart with similarly discarded electronics.
;****************************************************************
	list		p=16c73b
	#include	<p16c73b.inc>
	#include	"remote.inc"
	#include	"eyes.inc"
	#include	"phrase.inc"

;****************************************************************
; Super-Important Variables					*
;****************************************************************
; IRQ Handler Work, Status, and FSR Register Backups
; Note that we reserve two locations for these at the base
; of Bank 0 and Bank 1 since we don't know what the STATUS
; register will contain when an IRQ hits.
IRQ_Vars	udata 0x20
IRQ_BackW	res 1
IRQ_BackStatus	res 1
IRQ_BackFSR	res 1
IRQ_BackPCLATH	res 1
IRQ_DoubleVars	udata 0xA0
IRQ_Doubles	res 1

Attract_Vars	udata 0x24
Attract_DelLo	res 1
Attract_DelHi	res 1

;****************************************************************
; Code Start							*
;****************************************************************
; Reset Vector @ $0000
; Should just skip over the IRQ Handler below and
; start execution of the main routine.
Reset_Vec:	code 0x0000
	clrf	PCLATH
	clrf	STATUS
	goto	Sylvie_Setup

; IRQ Vector @ $0004
; All IRQs (including those from peripherals) will shove the PC
; over here, so we'll need to determine and handle all possible causes.
IRQ_Vec:	code 0x0004
	movwf	IRQ_BackW
	movf	STATUS,w
	clrf	STATUS
	movwf	IRQ_BackStatus
	movf	PCLATH,w
	clrf	PCLATH
	movwf	IRQ_BackPCLATH
	movf	FSR,w
	movwf	IRQ_BackFSR

	call	Phrase_IRQ
	call	Remote_IRQ
	
	clrf	STATUS
	movf	IRQ_BackPCLATH,w
	movwf	PCLATH
	movf	IRQ_BackFSR,w
	movwf	FSR
	movf	IRQ_BackStatus,w
	movwf	STATUS
	swapf	IRQ_BackW,f
	swapf	IRQ_BackW,w
	retfie

;****************************************************************
; Initialization and Main Routine				*
;****************************************************************
Sylvie_Setup:
; First, clear memory.
; $0-7F is Bank 0, and $A0-FF is Bank 1.
	movlw	0x20
	movwf	FSR
Sylvie_ClearMem_A
	clrf	INDF
	incf	FSR,f
	btfss	FSR,7
	goto	Sylvie_ClearMem_A

	movlw	0xA0
	movwf	FSR
Sylvie_ClearMem_B
	clrf	INDF
	incfsz	FSR,f
	goto	Sylvie_ClearMem_B
; Step through all of our initialization tasks, configure the
; I/O Pins, enable global and peripheral interrupts, then
; head off to attract mode until we get our first command.
	call	Eyes_Init
	call	Remote_Init
	call	Phrase_Init

	bsf	STATUS,RP0
; Port A (%xx000000, $C0)
;	7-6: Not in x73	(x)
;	5: SPI SEL	(O)
;	4-0: Rotation	(0)
	movlw	0xC0
	movwf	TRISA
; Port B (%00000000, $00):
;	7-0: Speech	(0)
	movlw	0x00
	movwf	TRISB
; Port C (%11010001, $D1):
;	7: USART RX	(O, But configured as I)
;	6: USART TX	(I)
;	5: SPI MOSI	(O)
;	4: SPI MISO	(I)
;	3: SPI CLK	(O)
;	2: PWM1/R	(O)
;	1: PWM2/L	(O)
;	0: Unusued	(I)
; Note that this will swap between $D1 and $D7 depending upon
; if the eye glow intensity is above or equal to zero.
	movlw	0xD1
	movwf	TRISC

; Turn on IRQs and we're ready to go...
	bcf	STATUS,RP0
	bsf	INTCON,PEIE
	bsf	INTCON,GIE

; '{SYL:Up}'
	call	Remote_SendPreface
	movlw	'U'
	call	Remote_SendChar
	movlw	'p'
	call	Remote_SendChar
	movlw	'}'
	call	Remote_SendChar

; Strobe Sylvie's eyes until we've received our first valid
; command, then shut off the eyes and head to the main loop.
Sylvie_AttractLoop:
	bcf	STATUS,RP0
	movf	Remote_GotCmd,f
	btfss	STATUS,Z
	goto	Sylive_AttractDone

	movlw	0xF0
	movwf	Attract_DelHi
Sylvie_AttractWait
	incfsz	Attract_DelLo,f
	goto	Sylvie_AttractWait
	incfsz	Attract_DelHi,f
	goto	Sylvie_AttractWait

	incf	Eye_Intensity,w
	call	Eyes_SetIntensity

	bcf	STATUS,RP0
	movf	Eye_Intensity,w
	btfss	STATUS,Z
	goto	Sylvie_AttractLoop
; '{SYL:--}'
	call	Remote_SendPreface
	movlw	'-'
	call	Remote_SendChar
	movlw	'-'
	call	Remote_SendChar
	movlw	'}'
	call	Remote_SendChar
	goto	Sylvie_AttractLoop
Sylive_AttractDone
	movlw	0x00
	call	Eyes_SetIntensity

; Sit tight, wait for something to do, it's all in IRQs!
; All we have to do is dispatch responses if we've been
; told to, just call Remote_HandleReq.
Sylive_MainLoop:
	call	Remote_HandleReq
	goto	Sylive_MainLoop
	END
